﻿var capiInterviewerSyncHistory = {
    context: $(".v-capiInterviewerSyncHistory"),
    datatable: null,
    interviewerId: null,
    initializeDataTable: function () {
        this.datatable = $(".h-capiSyncHistory-table", this.context).a4datatable({
            advancedFilter: false,
            displaySearchBox: false,
            ajaxAction: a4.getAction("GetCAPIInterviewerSyncHistories", "Diagnostics", "Project"),
            ajaxParams: { "interviewerId": capiInterviewerSyncHistory.interviewerId },
            columns: [
                { "Title": resources.StartDate, "Data": "StartDate", "Type": "date" },
                { "Title": resources.ProjectName, "Data": "ProjectName" },
                { "Title": resources.Interviewer, "Data": "Interviewer" },
                { "Title": resources.Workstation, "Data": "Workstation" },
                { "Title": resources.CaseID, "Data": "CaseID" },
                { "Title": resources.CaseResult, "Data": "CaseResult" },
                { "Title": resources.Completed, "Data": "Completed" },
                { "Title": resources.Status, "Data": "Status" },
                { "Title": resources.Comments, "Data": "Comments" },
                { "Title": resources.Action, "Data": "Action" }
            ],
            toolBarParams: {
                align: "right"
            },
            toolBar: {
                DisplayMode: dataTables.filterDisplayMode.dropdown,
                Items:[
                    { "Action": "clear", "Label": resources.Clear, "DisplayMode": dataTables.itemDisplayMode.always },
                    { "Action": "export", "Label": resources.Export, "DisplayMode": dataTables.itemDisplayMode.always }
                ]
            },
            toolBarClick: function (event, data) {
                var action = data.action;

                switch (action) {
                    case "clear":
                        capiModuleSyncHistory.clearTable();
                        break;
                    case "export":
                        capiModuleSyncHistory.exportExcel();
                        break;
                };

            },
            stateKey: "CAPIInterviewerSyncHistory",
            quickFilter: {
                "Items": [
                    { "Label": resources.Today, "AjaxParams": { "period": "today" } },
                    { "Label": resources.ThisWeek, "AjaxParams": { "period": "week" } },
                    { "Label": resources.ThisMonth, "AjaxParams": { "period": "month" } },
                    { "Label": resources.Custom, "AjaxParams": { "period": "custom" }, "CustomInputs": [{ "Label": resources.From, "Type": "date", "Key": "period_from" }, { "Label": resources.To, "Type": "date", "Key": "period_to" }] }
                ]
            }
        });
    },
    exportExcel: function () {
        a4.showBusyBox();

        a4.callServerMethod(a4.getProjectAction("ExportInterviewerSynchHistories", "Diagnostics"), { interviewerId: capiInterviewerSyncHistory.interviewerId },
        function (result) {
            a4.hideBusyBox();
            window.location = a4.getProjectAction("GetSynchHistoriesFile", "Diagnostics", { fileName: result });
        },
        function (error) {
            a4.onAjaxPageMethodError(error);
        });
    },
    clearTable: function () {
        modalDialog.showConfirmDialog(confirmDeleteSynchHistoryResources, function () {
            a4.callServerMethod(a4.getProjectAction("DeleteCAPIInterviewerSyncHistories", "Diagnostics"), { interviewerId: capiInterviewerSyncHistory.interviewerId },
                function () {
                    a4.showSuccessMessage(resources.ClearHistoryCompleted);
                    capiInterviewerSyncHistory.refreshContent();
                },
                function (error) {
                    a4.onAjaxPageMethodError(error);
                }
            );
        }, 250, 500, true);
    },
    refreshContent: function () {
        this.datatable.a4datatable("refresh");
    }
}

$(document).ready(function () {
    if (capiInterviewerSyncHistory.context.length > 0) {
        capiInterviewerSyncHistory.interviewerId = $("#InterviewerId", this.context).val();
        capiInterviewerSyncHistory.initializeDataTable();
    }
});